//
// Copyright (c) 2002
// Ronald Kevin Burton
//
// Z poniszym kodem nie jest zwizana adna gwarancja poprawnoci dziaania.
// Program zosta doczony do ksiki ".NET CLR. Ksiga eksperta" w celu
// ilustracji koncepcji i zasad przedstawionych w tej ksice. Program moe by 
// uywany na wasne ryzyko.
//
// Przyznaje si prawo do uycia lub kopiowania tego oprogramowania do dowolnego celu
// bez koniecznoci ponoszenia adnych opat pod warunkiem, e powysze uwagi zostan 
// zachowane we wszystkich kopiach. Przyznaje si take prawo do modyfikacji kodu
// i dystrybucji zmodyfikowanego kodu pod warunkiem zachowania powyszych uwag
// oraz doczenia informacji mwicej o modyfikacji kodu.
//
// 
using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Threading;
using System.Diagnostics;

namespace DiningPhilosophers
{
	public class DiningPhilosopher : System.Windows.Forms.Button
	{
		private Mutex [] chopsticks;
		private Thread stateHandler;
		// Zdefiniowanie specjalnego delegata, ktry obsuguje szeregowanie
		// informacji o zmianie koloru z wtku pracujcego w tle
		// do wtku zawierajcego przycisk.
		private delegate void ColorChangeDelegate(Color color);
		private ColorChangeDelegate colorChangeDelegate;
		private EventHandler onPhilosopherLeave;
		public DiningPhilosopher(Mutex rightChopstick, Mutex leftChopstick)
		{
			chopsticks = new Mutex[2];
			chopsticks[0] = rightChopstick;
			chopsticks[1] = leftChopstick;

			colorChangeDelegate = new ColorChangeDelegate(ColorChange);
			onPhilosopherLeave = new EventHandler(OnPhilosopherLeave);
			stateHandler = null;
		}
		public void Start()
		{
			stateHandler = new Thread(new ThreadStart(StateHandler));
			if(base.Name != null)
				stateHandler.Name = base.Name;
			stateHandler.Start();
		}
		public void Stop()
		{
			if(stateHandler != null)
				stateHandler.Abort();
		}
		/// <summary>
		/// Ta metoda jest wywoywana z wtku pracujcego w tle poprzez wywoanie
		/// BeginInvoke, dziki czemu zawsze odbywa si szeregowanie do wtku
		/// zawierajcego elementy sterujce list.
		/// </summary>
		/// <param name="files"></param>
		/// <param name="startIndex"></param>
		/// <param name="count"></param>
		private void ColorChange(Color color)
		{
			this.BackColor = color;
			this.Refresh();
		}
		public event EventHandler PhilosopherLeave;
		/// <summary>
		/// Ta metoda jest wywoywana przez wtek pracujcy w tle, 
		/// kiedy filozof zostanie poproszony o opuszczenie.
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void OnPhilosopherLeave(object sender, EventArgs e)
		{
			if (PhilosopherLeave != null)
			{
				PhilosopherLeave(sender, e);
			}
		}
        
		private void InitializeComponent()
		{
		}
	
		private void StateHandler()
		{
			int startThinkingTime = 0;
			int stopThinkingTime = 0;
			int elapsed = 0;
			// Uzyskanie cigu wyszukiwania. Przydziay poszczeglnych pl
			// s w .NET niepodzielne, przez co nie ma potrzeby wykorzystania
			// synchronizacji wtku do przechwycenia wartoci tego cigu.
			try 
			{
				// Zmiana koloru na niebieski (rozmylanie)
				BeginInvoke(colorChangeDelegate, new object[] {Color.Blue});
				startThinkingTime = Environment.TickCount;
				while(true)
				{
					if(WaitHandle.WaitAll(chopsticks, 100, false))
					{
						// Jedzenie
						BeginInvoke(colorChangeDelegate, new object[] {Color.Green});
						Thread.Sleep(500);
						chopsticks[0].ReleaseMutex();
						chopsticks[1].ReleaseMutex();
						BeginInvoke(colorChangeDelegate, new object[] {Color.Blue});
						startThinkingTime = Environment.TickCount;
						Thread.Sleep(0);
					}
					else
					{
						stopThinkingTime = Environment.TickCount;
						elapsed = stopThinkingTime - startThinkingTime;
						if(elapsed > 0 && elapsed <= 100)
						{
							BeginInvoke(colorChangeDelegate, new object[] {Color.BlueViolet});
						}
						else if(elapsed > 100 && elapsed <= 200)
						{
							BeginInvoke(colorChangeDelegate, new object[] {Color.Violet});
						}
						else if(elapsed > 200 && elapsed <= 300)
						{
							BeginInvoke(colorChangeDelegate, new object[] {Color.MediumVioletRed});
						}
						else if(elapsed > 300 && elapsed <= 400)
						{
							BeginInvoke(colorChangeDelegate, new object[] {Color.PaleVioletRed});
						}
						else if(elapsed > 400 && elapsed <= 500)
						{
							BeginInvoke(colorChangeDelegate, new object[] {Color.Yellow});
						}
						else if(elapsed > 500 && elapsed <= 600)
						{
							BeginInvoke(colorChangeDelegate, new object[] {Color.Gold});
						}
						else if(elapsed > 600 && elapsed <= 700)
						{
							BeginInvoke(colorChangeDelegate, new object[] {Color.Orange});
						}
						else if(elapsed > 700 && elapsed <= 800)
						{
							BeginInvoke(colorChangeDelegate, new object[] {Color.DarkOrange});
						}
						else if(elapsed > 800 && elapsed <= 900)
						{
							BeginInvoke(colorChangeDelegate, new object[] {Color.Chocolate});
						}
						else if(elapsed > 900 && elapsed <= 1000)
						{
							BeginInvoke(colorChangeDelegate, new object[] {Color.OrangeRed});
						}
						else
						{
							BeginInvoke(colorChangeDelegate, new object[] {Color.Red});
						}
					}
				}
			}
			finally
			{
				// Zakoczono jedzenie i rozmylanie

				// Zgoszenie zdarzenia powiadamiajcego uytkownika
				// o opuszczeniu stou przez filozofa.  
				// Nie jest konieczne wykonanie tego poprzez szeregowane wywoanie,
				// ale szeregowanie jest zalecane z poniszej przyczyny.
				// Uytkownicy tego elementu sterujcego nie wiedz, e jest on wielowtkowy,
				// przez co mog oczekiwa na powrt zdarze do tego samego wtku
				// co element sterujcy.
				BeginInvoke(colorChangeDelegate, new object[] {Color.White});
				BeginInvoke(onPhilosopherLeave, new object[] {this, EventArgs.Empty});
			}
		}
	}

	/// <summary>
	/// Podsumowanie dla Form1.
	/// </summary>
	public class TableForm : System.Windows.Forms.Form
	{
		private const int numberOfPhilosophers = 5;
		private Mutex [] chopsticks;
		private System.Windows.Forms.Button philosopher1;
		private System.Windows.Forms.Button philosopher2;
		private System.Windows.Forms.Button philosopher3;
		private System.Windows.Forms.Button philosopher4;
		private System.Windows.Forms.Button philosopher5;
		private System.Windows.Forms.Button startSession;
		private System.Windows.Forms.Button stopSession;
		/// <summary>
		/// Wymagana zmienna.
		/// </summary>
		private System.ComponentModel.Container components = null;

		public TableForm()
		{
			//
			// Wymagane do obsugi Windows Form Designer
			//
			InitializeComponent();
			foreach(Control b in Controls)
			{
				if(b is DiningPhilosopher)
				{
					b.BackColor = Color.White;
					b.Refresh();
				}
			}
		}

		/// <summary>
		/// Oczyszczenie uywanych zasobw.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Metoda wymagana do obsugi Designera - nie naley modyfikowa
		/// zawartoci tej metody przy uyciu edytora kodu.
		/// </summary>
		private void InitializeComponent()
		{
			chopsticks = new Mutex[numberOfPhilosophers];
			for(int i = 0; i < numberOfPhilosophers; i++)
			{
				chopsticks[i] = new Mutex();
			}
			this.philosopher1 = new DiningPhilosopher(chopsticks[0], chopsticks[1]);
			this.philosopher2 = new DiningPhilosopher(chopsticks[1], chopsticks[2]);
			this.philosopher3 = new DiningPhilosopher(chopsticks[2], chopsticks[3]);
			this.philosopher4 = new DiningPhilosopher(chopsticks[3], chopsticks[4]);
			this.philosopher5 = new DiningPhilosopher(chopsticks[4], chopsticks[0]);
			this.startSession = new System.Windows.Forms.Button();
			this.stopSession = new System.Windows.Forms.Button();
			this.SuspendLayout();
			// 
			// philosopher1
			// 
			this.philosopher1.BackColor = System.Drawing.Color.Green;
			this.philosopher1.Location = new System.Drawing.Point(176, 184);
			this.philosopher1.Name = "philosopher1";
			this.philosopher1.Size = new System.Drawing.Size(24, 24);
			this.philosopher1.TabIndex = 0;
			// 
			// philosopher2
			// 
			this.philosopher2.BackColor = System.Drawing.Color.Green;
			this.philosopher2.Location = new System.Drawing.Point(80, 120);
			this.philosopher2.Name = "philosopher2";
			this.philosopher2.Size = new System.Drawing.Size(24, 24);
			this.philosopher2.TabIndex = 0;
			// 
			// philosopher3
			// 
			this.philosopher3.BackColor = System.Drawing.Color.Green;
			this.philosopher3.Location = new System.Drawing.Point(112, 24);
			this.philosopher3.Name = "philosopher3";
			this.philosopher3.Size = new System.Drawing.Size(24, 24);
			this.philosopher3.TabIndex = 0;
			// 
			// philosopher4
			// 
			this.philosopher4.BackColor = System.Drawing.Color.Green;
			this.philosopher4.Location = new System.Drawing.Point(240, 24);
			this.philosopher4.Name = "philosopher4";
			this.philosopher4.Size = new System.Drawing.Size(24, 24);
			this.philosopher4.TabIndex = 0;
			// 
			// philosopher5
			// 
			this.philosopher5.BackColor = System.Drawing.Color.Green;
			this.philosopher5.Location = new System.Drawing.Point(272, 120);
			this.philosopher5.Name = "philosopher5";
			this.philosopher5.Size = new System.Drawing.Size(24, 24);
			this.philosopher5.TabIndex = 0;
			// 
			// startSession
			// 
			this.startSession.Location = new System.Drawing.Point(40, 240);
			this.startSession.Name = "startSession";
			this.startSession.TabIndex = 1;
			this.startSession.Text = "Start";
			this.startSession.Click += new System.EventHandler(this.OnStart);
			// 
			// stopSession
			// 
			this.stopSession.Location = new System.Drawing.Point(248, 240);
			this.stopSession.Name = "stopSession";
			this.stopSession.TabIndex = 2;
			this.stopSession.Text = "Stop";
			this.stopSession.Click += new System.EventHandler(this.OnStop);
			// 
			// TableForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(376, 273);
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
										    this.stopSession,
										    this.startSession,
										    this.philosopher1,
										    this.philosopher2,
										    this.philosopher3,
										    this.philosopher4,
										    this.philosopher5});
			this.Name = "TableForm";
			this.Text = "Filozofowie";
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// Gwny punkt wejcia dla aplikacji.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new TableForm());
		}

		private void OnStart(object sender, System.EventArgs e)
		{
			foreach(Control b in Controls)
			{
				if(b is DiningPhilosopher)
				{
					((DiningPhilosopher)b).Start();
				}
			}
		}

		private void OnStop(object sender, System.EventArgs e)
		{
			foreach(Control b in Controls)
			{
				if(b is DiningPhilosopher)
				{
					((DiningPhilosopher)b).Stop();
				}
			}
		}
	}
}
